/********************************************************************************/
/*																				*/
/*	Kroenke, Auer, Vandenberg, and Yoder 										*/
/*	Database Concepts (8th Edition) Appendix E 	  					     		*/
/*																				*/
/*  Garden Glory Database Views and SQL Queries									*/
/*																				*/
/*	These are the MySQL 5.7 SQL code solutions									*/
/*																				*/
/********************************************************************************/

/*****   Garden_Glory CREATE TABLE statements   *********************************/

/*       See the files:	 DBC-e08-MySQL-GG-Create-Tables.sql						*/

/*****   Garden_Glory INSERT statements   ***************************************/

/*       See the files:	 DBC-e08-MySQL-GG-Insert-Data.sql						*/

/*****   OWNER DATA   ***********************************************************/

SELECT * FROM OWNER;

/*****   EMPLOYEE DATA   ********************************************************/

SELECT * FROM EMPLOYEE;

/*****   OWNED_PROPERTY DATA   **************************************************/

SELECT * FROM OWNED_PROPERTY;

/*****   GG_SERVICE DATA   *******************************************************/

SELECT * FROM GG_SERVICE;

/*****   PROPERTY_SERVICE DATA   *************************************************/

SELECT * FROM PROPERTY_SERVICE;


/*****   Question A   ************************************************************/

ALTER TABLE EMPLOYEE
	ADD Supervisor Int NULL;

ALTER TABLE EMPLOYEE
	ADD CONSTRAINT EMP_EMP_FK FOREIGN KEY (Supervisor)
		REFERENCES EMPLOYEE (EmployeeID);

UPDATE EMPLOYEE
	SET Supervisor = 5 WHERE EmployeeID = 2;

UPDATE EMPLOYEE
	SET Supervisor = 1 WHERE EmployeeID = 3;

UPDATE EMPLOYEE
	SET Supervisor = 1 WHERE EmployeeID = 4;

/*****   Question B  ************************************************************/

ALTER TABLE EMPLOYEE
	ADD Apprenticeship	Varchar(20) NULL;

UPDATE EMPLOYEE
	SET Apprenticeship = 'Completed' WHERE EmployeeID = 1 OR EmployeeID = 4;

UPDATE EMPLOYEE
	SET Apprenticeship = 'In process' WHERE EmployeeID = 2 OR EmployeeID = 5;

UPDATE EMPLOYEE
	SET Apprenticeship = 'Not started' WHERE EmployeeID = 3;

ALTER TABLE EMPLOYEE
	MODIFY COLUMN Apprenticeship Varchar(20) NOT NULL;

/*****   Question D  ************************************************************/
/* MySQL does not enforce CHECKs */

ALTER TABLE EMPLOYEE
	ADD CONSTRAINT ApprenticeCheck CHECK
		(Apprenticeship IN ('Completed', 'In process', 'Not started'));

/*****   Question E  ************************************************************/

SELECT E.FirstName AS EmployeeFirstName,
	E.LastName AS EmployeeLastName,
	S.FirstName AS SupervisorFirstName,
	S.LastName AS SupervisorLastName
FROM EMPLOYEE E JOIN EMPLOYEE S
	ON E.Supervisor = S.EmployeeID;

/*****   Question F  ************************************************************/

SELECT E.FirstName AS EmployeeFirstName,
	E.LastName AS EmployeeLastName,
	S.FirstName AS SupervisorFirstName,
	S.LastName AS SupervisorLastName
FROM EMPLOYEE E LEFT JOIN EMPLOYEE S
	ON E.Supervisor = S.EmployeeID;

/*****   Question G  ************************************************************/

SELECT E1.EmployeeID, E1.FirstName, E1.LastName
FROM EMPLOYEE E1
WHERE EXISTS (SELECT *
	      FROM EMPLOYEE E2
	      WHERE E1.FirstName = E2.FirstName AND E1.LastName = E2.LastName
		AND E1.EmployeeID <> E2.EmployeeID);

/*****   Question H  ************************************************************/
/******  Create Function  *******************************************************/
DELIMITER //
CREATE FUNCTION FirstNameFirst 

-- These are the input parameters
(
	FirstName		CHAR(25),
	LastName		CHAR(25)
)
RETURNS VARCHAR(60) DETERMINISTIC

BEGIN
	-- This is the variable that will hold the value to be returned
	DECLARE FullName VARCHAR(60);

	-- SQL statements to concatenate the names in the proper order
	SET FullName = CONCAT(FirstName,' ', LastName);
	
	-- Return the concatentated name
	RETURN FullName;
END
//
DELIMITER ;

/******  Test Function  *********************************************************/

SELECT		FirstNameFirst(FirstName, LastName) AS EmployeeName, 
			CellPhone
FROM		EMPLOYEE
ORDER BY	EmployeeName;

/*****   Question I.1   *********************************************************/

CREATE VIEW OwnerPropertyView AS
	SELECT		O.OwnerID, OwnerName, PropertyType,
				PropertyID, PropertyName, Street, City, State, ZIP
	FROM 		OWNER AS O JOIN OWNED_PROPERTY AS P
					ON O.OwnerID = P.OwnerID;

/*****   Question I.2   *********************************************************/

CREATE VIEW PropertyServiceView AS
SELECT	P.PropertyID, PropertyName, Street, City, State, ZIP,
			ServiceDate, FirstName, LastName, HoursWorked
FROM 		OWNED_PROPERTY AS P JOIN PROPERTY_SERVICE AS PS
		ON P.PropertyID = PS.PropertyID
			JOIN EMPLOYEE AS E
				ON E.EmployeeID = PS.EmployeeID;

/*****   Question I.3   *********************************************************/

CREATE VIEW PropertyServiceFirstNameFirstView AS
	SELECT		P.PropertyID, PropertyName, Street, City, State, ZIP,
				ServiceDate,
				FirstNameFirst(FirstName, LastName) AS EmployeeName, 
				HoursWorked
	FROM 		OWNED_PROPERTY AS P JOIN PROPERTY_SERVICE AS PS
		ON		P.PropertyID = PS.PropertyID
				JOIN EMPLOYEE AS E
		ON		PS.EmployeeID = E.EmployeeID;

/*****   Question J.1   *********************************************************/

SELECT		*
FROM		OwnerPropertyView
ORDER BY	OwnerName;

/*****   Question J.2   *********************************************************/

SELECT		*
FROM		PropertyServiceView
ORDER BY	ZIP, State, City;

/*****   Question J.3   *********************************************************/

SELECT		*
FROM		PropertyServiceFirstNameFirstView
ORDER BY	ZIP, State, City;

/*****   Question K.1  *******************************************************/

/* NO DATABASE ACTIVITY IN THIS QUESTION */

/*****   Question K.2  *******************************************************/

ALTER TABLE TOOLS
	MODIFY COLUMN ToolID Int NOT NULL;

ALTER TABLE TOOL_USE
	MODIFY COLUMN ToolID Int NOT NULL;

ALTER TABLE TOOL_USE
	ADD EmployeeID Int NOT NULL;

UPDATE TOOL_USE
	SET EmployeeID = 2 WHERE UsedBy = 'John Evanston';

UPDATE TOOL_USE
	SET EmployeeID = 4 WHERE UsedBy = 'Jerry Murphy';

UPDATE TOOL_USE
	SET EmployeeID = 5 WHERE UsedBy = 'Joan Fontaine';

UPDATE TOOL_USE
	SET EmployeeID = 1 WHERE UsedBy = 'Sam Smith';

ALTER TABLE TOOLS
	ADD CONSTRAINT TOOLS_PK PRIMARY KEY (ToolID);

ALTER TABLE TOOL_USE
	MODIFY COLUMN Date DATETIME NOT NULL;

ALTER TABLE TOOL_USE
	ADD CONSTRAINT TOOL_USE_PK PRIMARY KEY (ToolID, EmployeeID, Date);

ALTER TABLE TOOL_USE
	DROP COLUMN UsedBy;


/*****   Question K.3 *******************************************************/

ALTER TABLE TOOL_USE
	ADD CONSTRAINT TU_TOOL_FK FOREIGN KEY (ToolID) 
			REFERENCES TOOLS (ToolID);

ALTER TABLE TOOL_USE
	ADD CONSTRAINT TU_EMP_FK FOREIGN KEY (EmployeeID) 
			REFERENCES EMPLOYEE (EmployeeID);

/********************************************************************************/

